﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.IO;
using System.IO.IsolatedStorage;
using System.Xml.Serialization;

namespace XMLSerzializer
{
    public partial class MainPage : PhoneApplicationPage
    {
        private List<Student> student; 
        // Constructor
        public MainPage()
        {
            InitializeComponent();
            
            student = new List<Student>();

            student.Add(new Student() { FirstName = "Jane", 
                LastName = "Doe", StudentNumber = 123456 });
            student.Add(new Student() { FirstName = "John", 
                LastName = "Doe", StudentNumber = 987654 });

            #region "serialze"
            using (IsolatedStorageFile file =
                IsolatedStorageFile.GetUserStoreForApplication())
            {
                using (IsolatedStorageFileStream stream =
                    file.CreateFile("Students.xml"))
                {
                    XmlSerializer xs = new XmlSerializer(typeof(List<Student>));
                    xs.Serialize(stream, student);
                    student = null;
                }
            }
            #endregion


            # region "deserialize"
            using (IsolatedStorageFile file =
                IsolatedStorageFile.GetUserStoreForApplication())
            {
                using (IsolatedStorageFileStream stream =
                    file.OpenFile("Students.xml", FileMode.Open))
                {
                    XmlSerializer xs = new XmlSerializer(typeof(List<Student>));
                    student = (List<Student>)xs.Deserialize(stream);
                    lbStudents.ItemsSource = student;
                }
            }
            #endregion
        }
     
        public class Student
        {
            public long StudentNumber {get; set;}
            public string FirstName { get; set; }
            public string LastName { get; set; }
        }
    }
}